(*********************************************************************************
* Copyright: Bernecker+Rainer
* Author:    Mikael Regard
* Created:   May 13, 2019/8:21 AM 
* Updated:   Aug 19, 2019/09:00 AM
 *********************************************************************************
 * Description:
 * FuB to handle group of Xbot.
 * Max 12 xbots per group
 * 
 *Input:
 * MsgFrame  (Profinet output frame)
 * ReadFrame (Profinet reply frame)
 * Execute   (Edgepos, Execute = TRUE will run the FuB once)
 * Cmd Label (Optional 2 byte Command label. Used to identify specfic commands.
 * XbotID[0..11]   (Any positive integer represent a particular Xbot)
 * NumOfXbot (Number of Xbot to control. min 1 max 12)
 * GroupID  (ID of the Group, 0 = all group, max 10 groups)
 * GroupOption (0 = Add Xbot to empty group, 1 = Clear Group, 2 = Connect all Xbot, 3 = Disconnect Group, 4 = Block motion buffers for all XBOT in group, 5 = Release motion buffer for all XBOT in group, Query status of groups)
 *
 * Output:
 * Error (Indicates if there is an error)
 * Busy  (FuB will be Busy until reply)
 * Done  (When Accepted command is received, Done = TRUE)
 * ConnectedStatus (Connected status. 0x0 = Disconnected. 0x1 = Connected)
 * NumXbotGroup (Number of Xbot in group commands in buffer)
 * GroupXbotID  (List of Xbot ID in group. Listed in the order they were added.)
 * ErrorID (0x0001 = System Error, 0x2000 = Wrong PMC State, 0x2001 = No Mastership, 0x2002 = Mastership timeout,
 *		    0x2003 = Wrong group state, 0x2004 = Wrong Macro state, 0x2005 = Wrong Digital IO state,
 *          0x2006 = Wrong flyways state, 0x3000 = Wrong Xbot state, 0x4000 = Paramter Error: Invalid Parameters.
 *********************************************************************************)






FUNCTION_BLOCK PM_GroupOp		
	// Check Reply
	IF(Busy)THEN
		brsmemcpy(ADR(CmdLbl),ADR(ReadFrame[3]),2);
		IF(ReadFrame[0] = CmdCount AND
			ReadFrame[1] 	= 22  AND
			ReadFrame[2]	= 11 AND
			CmdLbl = CmdLabel)THEN
			Done 	:= TRUE;
			Busy 	:= FALSE;
			brsmemcpy(ADR(ErrorID),ADR(ReadFrame[5]),2);
			Error 	:= UINT_TO_BOOL(ErrorID);
			Done 	:= NOT(UINT_TO_BOOL(ErrorID));
			ConnectedStatus := ReadFrame[10];
			NumXbotGroup    := ReadFrame[11];
			FOR count := 0 TO NumXbotGroup DO
				GroupXbotID[count] := ReadFrame[12+count];
			END_FOR
		ELSE
			Busy := FALSE;
		END_IF;
	END_IF;
	//Send Command		
	IF(Execute AND NOT(Done) AND NOT(Error))THEN
		IF(NOT(Busy))THEN
			brsmemset(ADR(MsgFrame[1]),FALSE,98);
			CmdCount 		:= ReadFrame[0] +1;
			MsgFrame[0] 	:= CmdCount; 
			MsgFrame[1] 	:= 22;
			MsgFrame[2] 	:= 11;
			brsmemcpy(ADR(MsgFrame[3]), ADR(CmdLabel), 2);
			MsgFrame[5]		:= 1;
			MsgFrame[6]		:= GroupOption;
			MsgFrame[9]		:= GroupID;
			MsgFrame[10]	:= NumOfXbot;			
			FOR count := 0 TO NumOfXbot DO
				MsgFrame[11+count] := XbotID[count];
			END_FOR;
			Busy := TRUE;	
		END_IF;
		//Reset Output
		
	ELSIF(NOT(Execute))THEN
		Busy := FALSE;
		Done := FALSE;
		Error := FALSE;
		ErrorID := 0;
	END_IF
	
	
	
END_FUNCTION_BLOCK
